package edu.cmu.cs.cs214.concurrencyframework;

import java.util.concurrent.ForkJoinPool;

public class PrefixSumsParallelImpl implements PrefixSums {

	/**
	 * This implementation has an unchecked precondition that the input array
	 * length is a power of 2.
	 */
	@Override
	public void computePrefixSums(long[] a) {
		ForkJoinPool pool = new ForkJoinPool();
		computeRecursive(a, 0, a.length, 1, pool);
	}
	
	public void computeRecursive(long[] a, final int left, final int right, final int gap, ForkJoinPool pool) {
		final int twiceGap = 2*gap;
		if (left+twiceGap-1 >= right) {
			return;
		}
		
		pool.invoke(new PrefixSumsParallelLoop1(a, left, right, gap, twiceGap));		
		
		computeRecursive(a, left, right, twiceGap, pool);
		
		pool.invoke(new PrefixSumsParallelLoop2(a, left, right, gap, twiceGap));
	}

}
